/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.biome;

import com.google.common.base.Preconditions;
import java.util.IdentityHashMap;
import java.util.Map;
import net.fabricmc.fabric.impl.biome.WeightedPicker;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2378;
import net.minecraft.class_2919;
import net.minecraft.class_3756;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_5820;
import net.minecraft.class_6880;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class TheEndBiomeData {
    private static final Map<class_5321<class_1959>, WeightedPicker<class_5321<class_1959>>> END_BIOMES_MAP = new IdentityHashMap<class_5321<class_1959>, WeightedPicker<class_5321<class_1959>>>();
    private static final Map<class_5321<class_1959>, WeightedPicker<class_5321<class_1959>>> END_MIDLANDS_MAP = new IdentityHashMap<class_5321<class_1959>, WeightedPicker<class_5321<class_1959>>>();
    private static final Map<class_5321<class_1959>, WeightedPicker<class_5321<class_1959>>> END_BARRENS_MAP = new IdentityHashMap<class_5321<class_1959>, WeightedPicker<class_5321<class_1959>>>();

    private TheEndBiomeData() {
    }

    public static void addEndBiomeReplacement(class_5321<class_1959> replaced, class_5321<class_1959> variant, double weight) {
        Preconditions.checkNotNull(replaced, (Object)"replaced entry is null");
        Preconditions.checkNotNull(variant, (Object)"variant entry is null");
        Preconditions.checkArgument((weight > 0.0 ? 1 : 0) != 0, (String)"Weight is less than or equal to 0.0 (got %s)", (Object)weight);
        END_BIOMES_MAP.computeIfAbsent(replaced, key -> new WeightedPicker()).add(variant, weight);
    }

    public static void addEndMidlandsReplacement(class_5321<class_1959> highlands, class_5321<class_1959> midlands, double weight) {
        Preconditions.checkNotNull(highlands, (Object)"highlands entry is null");
        Preconditions.checkNotNull(midlands, (Object)"midlands entry is null");
        Preconditions.checkArgument((weight > 0.0 ? 1 : 0) != 0, (String)"Weight is less than or equal to 0.0 (got %s)", (Object)weight);
        END_MIDLANDS_MAP.computeIfAbsent(highlands, key -> new WeightedPicker()).add(midlands, weight);
    }

    public static void addEndBarrensReplacement(class_5321<class_1959> highlands, class_5321<class_1959> barrens, double weight) {
        Preconditions.checkNotNull(highlands, (Object)"highlands entry is null");
        Preconditions.checkNotNull(barrens, (Object)"midlands entry is null");
        Preconditions.checkArgument((weight > 0.0 ? 1 : 0) != 0, (String)"Weight is less than or equal to 0.0 (got %s)", (Object)weight);
        END_BARRENS_MAP.computeIfAbsent(highlands, key -> new WeightedPicker()).add(barrens, weight);
    }

    public static Overrides createOverrides(class_2378<class_1959> biomeRegistry, long seed) {
        return new Overrides(biomeRegistry, seed);
    }

    static {
        END_BIOMES_MAP.computeIfAbsent((class_5321<class_1959>)class_1972.field_9411, key -> new WeightedPicker()).add(class_1972.field_9411, 1.0);
        END_BIOMES_MAP.computeIfAbsent((class_5321<class_1959>)class_1972.field_9442, key -> new WeightedPicker()).add(class_1972.field_9442, 1.0);
        END_BIOMES_MAP.computeIfAbsent((class_5321<class_1959>)class_1972.field_9457, key -> new WeightedPicker()).add(class_1972.field_9457, 1.0);
        END_MIDLANDS_MAP.computeIfAbsent((class_5321<class_1959>)class_1972.field_9442, key -> new WeightedPicker()).add(class_1972.field_9447, 1.0);
        END_BARRENS_MAP.computeIfAbsent((class_5321<class_1959>)class_1972.field_9442, key -> new WeightedPicker()).add(class_1972.field_9465, 1.0);
    }

    public static class Overrides {
        private final class_3756 sampler;
        private final class_6880<class_1959> endMidlands;
        private final class_6880<class_1959> endBarrens;
        private final class_6880<class_1959> endHighlands;
        private final Map<class_6880<class_1959>, WeightedPicker<class_6880<class_1959>>> endBiomesMap;
        private final Map<class_6880<class_1959>, WeightedPicker<class_6880<class_1959>>> endMidlandsMap;
        private final Map<class_6880<class_1959>, WeightedPicker<class_6880<class_1959>>> endBarrensMap;

        public Overrides(class_2378<class_1959> biomeRegistry, long seed) {
            this.sampler = new class_3756((class_5819)new class_2919((class_5819)new class_5820(seed)));
            this.endMidlands = biomeRegistry.method_40290(class_1972.field_9447);
            this.endBarrens = biomeRegistry.method_40290(class_1972.field_9465);
            this.endHighlands = biomeRegistry.method_40290(class_1972.field_9442);
            this.endBiomesMap = this.resolveOverrides(biomeRegistry, END_BIOMES_MAP);
            this.endMidlandsMap = this.resolveOverrides(biomeRegistry, END_MIDLANDS_MAP);
            this.endBarrensMap = this.resolveOverrides(biomeRegistry, END_BARRENS_MAP);
        }

        private Map<class_6880<class_1959>, WeightedPicker<class_6880<class_1959>>> resolveOverrides(class_2378<class_1959> biomeRegistry, Map<class_5321<class_1959>, WeightedPicker<class_5321<class_1959>>> overrides) {
            IdentityHashMap<class_6880<class_1959>, WeightedPicker<class_6880<class_1959>>> result = new IdentityHashMap<class_6880<class_1959>, WeightedPicker<class_6880<class_1959>>>(overrides.size());
            for (Map.Entry<class_5321<class_1959>, WeightedPicker<class_5321<class_1959>>> entry : overrides.entrySet()) {
                result.put((class_6880<class_1959>)biomeRegistry.method_40290(entry.getKey()), entry.getValue().map(arg_0 -> biomeRegistry.method_40290(arg_0)));
            }
            return result;
        }

        public class_6880<class_1959> pick(int x, int y, int z, class_6880<class_1959> vanillaBiome) {
            class_6880<class_1959> replacementKey;
            if (vanillaBiome == this.endMidlands || vanillaBiome == this.endBarrens) {
                WeightedPicker<class_6880<class_1959>> barrensPicker;
                WeightedPicker<class_6880<class_1959>> midlandsPicker;
                WeightedPicker<class_6880<class_1959>> highlandsPicker = this.endBiomesMap.get(this.endHighlands);
                class_6880<class_1959> highlandsKey = highlandsPicker.pickFromNoise(this.sampler, (double)x / 64.0, 0.0, (double)z / 64.0);
                replacementKey = vanillaBiome == this.endMidlands ? ((midlandsPicker = this.endMidlandsMap.get(highlandsKey)) == null ? vanillaBiome : midlandsPicker.pickFromNoise(this.sampler, (double)x / 64.0, 0.0, (double)z / 64.0)) : ((barrensPicker = this.endBarrensMap.get(highlandsKey)) == null ? vanillaBiome : barrensPicker.pickFromNoise(this.sampler, (double)x / 64.0, 0.0, (double)z / 64.0));
            } else {
                WeightedPicker<class_6880<class_1959>> picker = this.endBiomesMap.get(vanillaBiome);
                replacementKey = picker.pickFromNoise(this.sampler, (double)x / 64.0, 0.0, (double)z / 64.0);
            }
            return replacementKey;
        }
    }
}

